model:setName( "TonalContrastIII" )
model:caption( "Tonal Contrast III" )

model:addSource("inputImage")
model:addSource("originalImage")
model:addSource("histogram0")
model:addSource("histogram1")
model:addSource("histogram2")
model:addSource("histogram3")
model:addSource("histogram4")
model:addSource("histogram5")

--basis filter added
f1= model:addFilter("LscAndSinterFilter")
f2= model:addFilter("LevelsAndCurvesFilter")	
lsc = model:getFilter(f1)
filter2 = model:getFilter(f2)

--curves---------------------

curve_neutral = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="0"/>
<key name="intNodeX0" value="0"/><key name="intNodeY0" value="0"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_slight_s = [[ <Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="2"/>
<key name="intNodeX0" value="0.961111"/><key name="intNodeY0" value="0.983333"/><key name="intNodeX1" value="0.0388889"/><key name="intNodeY1" value="0.0166667"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]



--lscValues--------------------------------------
lsc:setIntParameter( "sinterStrucLscMode0_", 4  )
lsc:setIntParameter( "sinterStrucLscMode1_" ,0 )
lsc:setIntParameter( "tileSizeLevel0", 0 )
lsc:setIntParameter( "tileSizeLevel1", 0 )
lsc:setIntParameter( "selectedChannel0_", 0 )
lsc:setIntParameter( "selectedChannel1_", 0 )
lsc:setFloatParameter( "sigma20", 30 )
lsc:setFloatParameter( "sigma21", 40 )
lsc:setIntParameter("lemmingType0", 0 )
lsc:setIntParameter( "lemmingType1",0 )
lsc:setFloatParameter("maxDeriv0", 3 )
lsc:setFloatParameter( "maxDeriv1", 2 )
lsc:setFloatParameter( "strength0", 100 )
lsc:setFloatParameter( "strength1", 0 )
lsc:setFloatParameter( "strengthFactor", 100 )
lsc:setFloatParameter( "totalStrength", 100 )
lsc:setFloatParameter( "brightness", 0)
lsc:setFloatParameter( "contrast", 12 )
lsc:setFloatParameter( "saturation", 0)
lsc:setFloatParameter( "csStrength", 1.0 )
lsc:setFloatParameter( "deltaT", 27 )
lsc:setFloatParameter( "numberOfTimesteps", 4)
lsc:setFloatParameter( "modifier_A", 0.9)
lsc:setFloatParameter( "modifier_B", 20)
lsc:setFloatParameter( "modifier_C", 2.5)
lsc:setFloatParameter( "modifier_D", 255)

-- slight s-curve on demand
filter2:setLacData( "lacdataRGB", curve_neutral ) -- used to be "slight_s"
filter2:setLacData( "lacdataR", curve_neutral )
filter2:setLacData( "lacdataG", curve_neutral )
filter2:setLacData( "lacdataB", curve_neutral )
filter2:setLacData( "lacdataSmartBrightness", curve_neutral )
filter2:setFloatParameter( "strength", 0 )


--  f1 = addFilter("LSCFilter");
--  lsc = getFilter(f1)
--  lsc:getFloatParameterValue(..)

--model:forwardFloatParameter("totalStrength", f1, "totalStrength", 80, 0, 100, "Tonal Contrast", "" ) 
model:forwardFloatParameter("strength0_hi" , f1, "strength0_hi" , 25, -100, 100, "Highlights", "" ) 
model:forwardFloatParameter("strength0_med", f1, "strength0_med", 50, -100, 100, "Midtones", "" )
model:forwardFloatParameter("strength0_low", f1, "strength0_low", 25, -100, 100, "Shadows", "" ) 
model:forwardFloatParameter("saturation", f1, "saturation", 20, -100, 100, "Saturation", "" ) 

-- Function for the TCTypeCombo combo box
function setTCType(v)

	value = lsc:getFloatParameterValue("strength0_med")
	if (value < 0) then
		value = 0
	end	
	lsc:setFloatParameter( "csStrength", 1.0 * value / 100 )
	
    if (v == 0) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 1 )
		lsc:setFloatParameter( "sigma20", 37 )
		lsc:setFloatParameter("maxDeriv0", 3 )
		lsc:setFloatParameter( "strength0", 100 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 0 )--
		lsc:setFloatParameter( "sigma21", 37 )--
		lsc:setFloatParameter("maxDeriv1", 3 )--

		lsc:setFloatParameter( "contrast", 0 )
		lsc:setFloatParameter( "modifier_A", 1.0)
		lsc:setFloatParameter( "modifier_A", midpos)
		lsc:setFloatParameter( "modifier_C", 2.0)
		filter2:setFloatParameter( "strength", 0 )
		
		lsc:setFloatParameter( "strength1", 0 * value / 100  ) -- strength1 parameter should be set here. 
		
	elseif (v == 1) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 1 )
		lsc:setFloatParameter( "sigma20", 200 )
		lsc:setFloatParameter("maxDeriv0", 3 )
		lsc:setFloatParameter( "strength0", 40 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 0 )--
		lsc:setFloatParameter( "sigma21", 200 )--
		lsc:setFloatParameter("maxDeriv1", 3 )--
		lsc:setFloatParameter( "contrast", 0 )
		lsc:setFloatParameter( "modifier_A", 2.0)
		lsc:setFloatParameter( "modifier_A", midpos)
		lsc:setFloatParameter( "modifier_C", 4.0)
		filter2:setFloatParameter( "strength", 0 )
		
		lsc:setFloatParameter( "strength1", 0 * value / 100  ) -- strength1 parameter should be set here. 
		
	elseif (v == 2) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 0 )
		lsc:setFloatParameter( "sigma20", 27 )
		lsc:setFloatParameter("maxDeriv0", 3 )
		lsc:setFloatParameter( "strength0", 100 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 0 )--
		lsc:setFloatParameter( "sigma21", 37 )--
		lsc:setFloatParameter("maxDeriv1", 3 )--
		lsc:setFloatParameter( "contrast", 0 )
		lsc:setFloatParameter( "modifier_A", 0.8)
		lsc:setFloatParameter( "modifier_C", 2.5)
		filter2:setFloatParameter( "strength", 0 )
		
		lsc:setFloatParameter( "strength1", 0 * value / 100  ) -- strength1 parameter should be set here. 
		
	elseif (v == 3) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 2 )
		lsc:setFloatParameter( "sigma20", 30 )
		lsc:setFloatParameter("maxDeriv0", 3 )
		lsc:setFloatParameter( "strength0", 75 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 0 )--
		lsc:setFloatParameter( "sigma21", 37 )--
		lsc:setFloatParameter("maxDeriv1", 3 )--
		lsc:setFloatParameter( "contrast", -8 )
		lsc:setFloatParameter( "modifier_A", 0.6)
		lsc:setFloatParameter( "modifier_C", 2.5)
		filter2:setFloatParameter( "strength", 0 )
		
		lsc:setFloatParameter( "strength1", 40 * value / 100  ) -- strength1 parameter should be set here. 
		
	elseif (v == 4) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 0 )
		lsc:setFloatParameter( "sigma20", 30 )
		lsc:setFloatParameter("maxDeriv0", 3 )
		lsc:setFloatParameter( "strength0", 75 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 0 )--
		lsc:setFloatParameter( "sigma21", 37 )--
		lsc:setFloatParameter("maxDeriv1", 3 )--
		lsc:setFloatParameter( "contrast", -20 )
		lsc:setFloatParameter( "modifier_A", 2.2)
		lsc:setFloatParameter( "modifier_C", 2.2)
		filter2:setFloatParameter( "strength", 0 )
		
		lsc:setFloatParameter( "strength1", 50 * value / 100  ) -- strength1 parameter should be set here. 
		
	elseif (v == 5) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 1 )
		lsc:setFloatParameter( "sigma20", 30 )
		lsc:setFloatParameter("maxDeriv0", 3 )
		lsc:setFloatParameter( "strength0", 75 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 1 )--
		lsc:setFloatParameter( "sigma21", 37 )--
		lsc:setFloatParameter("maxDeriv1", 3 )--
		lsc:setFloatParameter( "contrast", -20 )
		lsc:setFloatParameter( "modifier_A", 2.2)
		lsc:setFloatParameter( "modifier_C", 2.2)
		filter2:setFloatParameter( "strength", 50 )
		
		lsc:setFloatParameter( "strength1", 50 * value / 100  ) -- strength1 parameter should be set here. 
		
	elseif (v == 6) then
		lsc:setIntParameter( "sinterStrucLscMode0_", 4 )
		lsc:setIntParameter( "tileSizeLevel0", 2 )
		lsc:setFloatParameter( "sigma20", 40 )
		lsc:setFloatParameter("maxDeriv0", 6 )
		lsc:setFloatParameter( "strength0", 75 )
		lsc:setIntParameter( "sinterStrucLscMode1_", 0 )--
		lsc:setIntParameter( "tileSizeLevel1", 2 )--
		lsc:setFloatParameter( "sigma21", 37 )--
		lsc:setFloatParameter("maxDeriv1", 6 )--
		lsc:setFloatParameter( "contrast", -20 )
		lsc:setFloatParameter( "modifier_A", 2.2)
		lsc:setFloatParameter( "modifier_C", 2.2)
		filter2:setFloatParameter( "strength", 100 )
		
		lsc:setFloatParameter( "strength1", 50 * value / 100  )  -- strength1 parameter should be set here. 
		
	end
end

model:addCombobox( "TCTypeCombo", "setTCType", "Contrast Type", "Standard;High Pass;Fine;Balanced;Strong" )
model:setIntParameter( "TCTypeCombo" , 0)


-- Protect Hi/Sh
function protect_shadows_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectShadows", v*100)
end
model:addFloatSlider("protect_shadows", 0,0,1,"protect_shadows_function", "Shadows", "")

function protect_hilights_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectHighlights", v*100)
end
model:addFloatSlider("protect_hilights", 0,0,1,"protect_hilights_function", "Highlights", "")
